<?php
/*
Plugin Name: Business Quotes
Description: Zobrazuje náhodné citáty o podnikání.
Version: 1.1
Author: Petr Novák - digitalstrategy.cz
*/

function bq_load_quotes() {
    $quotes_file = plugin_dir_path(__FILE__) . 'quotes.json';

    if (!file_exists($quotes_file)) {
        return []; // Soubor neexistuje
    }

    $quotes_json = file_get_contents($quotes_file);
    $quotes = json_decode($quotes_json, true);

    if (!is_array($quotes)) {
        return []; // JSON se nepodařilo dekódovat
    }

    return $quotes;
}

function bq_display_quote() {
    $quotes = bq_load_quotes();

    if (empty($quotes)) {
        return "<p><em>Citáty nejsou dostupné. Zkontrolujte soubor quotes.json.</em></p>";
    }

    $random_quote = $quotes[array_rand($quotes)];
    return "<blockquote style='font-style: italic; border-left: 3px solid #ccc; padding-left: 10px;'>{$random_quote['text']}<br><small>— {$random_quote['author']}</small></blockquote>";
}

function bq_shortcode() {
    return bq_display_quote();
}
add_shortcode('business_quote', 'bq_shortcode');
